<div dir="rtl">
# آزادی دی‌ان‌اس تستر

**Languages:** [English](README.md) | [فارسی](README-fa.md)

**آزادی دی‌ان‌اس تستر** - سرورهای DNS را از فایل `dns_servers.txt` تست کرده و سرورهای فعال را در `working_dns.txt` ذخیره می‌کند.

مناسب برای پیدا کردن سرورهای DNS در دسترس در شبکه‌های محدود شده.

---

## سه روش برای تست سرورهای DNS

| روش | پلتفرم | وابستگی‌ها | مناسب برای |
|-----|--------|------------|------------|
| **پایتون** | همه | پایتون + پکیج‌های pip | امکانات کامل، بهترین تجربه کاربری |
| **بش** | لینوکس/مک | هیچ (ابزارهای داخلی) | شبکه‌های محدود |
| **پاورشل** | ویندوز | هیچ (cmdlet های داخلی) | شبکه‌های محدود |

---

## ۱. اسکریپت پایتون (امکانات کامل)

نسخه پایتون بهترین تجربه کاربری را با نوار پیشرفت، خروجی رنگی و زمان‌سنجی دقیق ارائه می‌دهد.

### پیش‌نیازها
- پایتون ۳.۶ یا بالاتر
- پکیج‌های `dnspython` و `tqdm`

### نصب
```bash
pip install dnspython tqdm
```

### استفاده
```bash
python AzadiDNSTester.py
```

### امکانات
- ✅ منوی تعاملی برای تعداد کارگر، تایم‌اوت و دامنه تست
- ✅ نوار پیشرفت بلادرنگ با `tqdm`
- ✅ تست موازی با تعداد کارگر قابل تنظیم
- ✅ خروجی رنگی در ترمینال
- ✅ زمان‌سنجی با دقت میلی‌ثانیه
- ✅ ذخیره نتایج به صورت بلادرنگ

---

## ۲. اسکریپت بش (بدون وابستگی - لینوکس/مک)

یک اسکریپت بش مستقل که روی هر سیستم لینوکس یا مک بدون نیاز به پایتون یا هرگونه وابستگی خارجی کار می‌کند. مناسب برای اشتراک‌گذاری با کاربران در شبکه‌های محدود.

### پیش‌نیازها
- بش ۳.x یا بالاتر (از قبل روی مک/لینوکس نصب است)
- یکی از: `dig`، `host` یا `nslookup` (معمولاً از قبل نصب است)

### استفاده
```bash
chmod +x AzadiDNSTester.sh
./AzadiDNSTester.sh
```

### امکانات
- ✅ بدون وابستگی خارجی - فقط از ابزارهای داخلی استفاده می‌کند
- ✅ تشخیص خودکار ابزار DNS (ترجیح: `dig` ← `host` ← `nslookup`)
- ✅ تست موازی با کارگرهای قابل تنظیم از طریق `xargs -P`
- ✅ نمایش پیشرفت بلادرنگ
- ✅ زمان‌سنجی دقیق در صورت وجود `perl Time::HiRes`
- ✅ کار روی مک (بش ۳.x) و لینوکس (بش ۴.x و بالاتر)
- ✅ استخراج آدرس‌های IPv4 از هر فرمت ورودی

### اولویت ابزار DNS
۱. **dig** (بهترین) - قابل اعتمادترین، پشتیبانی داخلی از تایم‌اوت
۲. **host** - جایگزین خوب، پشتیبانی از تایم‌اوت
۳. **nslookup** - گزینه جایگزین، کنترل محدود تایم‌اوت

---

## ۳. اسکریپت پاورشل (بدون وابستگی - ویندوز)

یک اسکریپت پاورشل مستقل برای کاربران ویندوز که نیازی به وابستگی خارجی ندارد. با هر دو Windows PowerShell 5.1 و PowerShell 7+ کار می‌کند.

### پیش‌نیازها
- Windows PowerShell 5.1 یا بالاتر (از قبل روی ویندوز ۱۰/۱۱ نصب است)
- یا PowerShell 7+ (چند پلتفرمی)

### استفاده
```powershell
# حالت تعاملی
.\AzadiDNSTester.ps1

# حالت غیرتعاملی با پارامترها
.\AzadiDNSTester.ps1 -NonInteractive -Workers 50 -Timeout 3 -Domain google.com
```

### امکانات
- ✅ بدون وابستگی خارجی - فقط از cmdlet های داخلی استفاده می‌کند
- ✅ استفاده از cmdlet `Resolve-DnsName` (یا `nslookup` به عنوان جایگزین)
- ✅ تست موازی:
  - PowerShell 7+: `ForEach-Object -Parallel`
  - PowerShell 5.1: Runspace pools
- ✅ نمایش پیشرفت بلادرنگ
- ✅ زمان‌سنجی دقیق با `[Stopwatch]`
- ✅ نوشتن امن در فایل (thread-safe)
- ✅ پشتیبانی از حالت غیرتعاملی برای اتوماسیون

### پارامترها
| پارامتر | توضیحات | پیش‌فرض |
|---------|---------|---------|
| `-Workers` | تعداد تست‌های موازی | ۱۰۰ |
| `-Timeout` | تایم‌اوت هر تست (ثانیه) | ۳ |
| `-Domain` | دامنه برای resolve کردن | google.com |
| `-NonInteractive` | بدون منو، استفاده از پیش‌فرض/پارامترها | false |

---

## فرمت فایل ورودی

همه اسکریپت‌ها از فایل `dns_servers.txt` در همان دایرکتوری می‌خوانند. اسکریپت‌ها به طور خودکار آدرس‌های IPv4 را از **هر فرمتی** استخراج می‌کنند:

```
# کامنت‌ها نادیده گرفته می‌شوند
1.1.1.1
8.8.8.8
Server: 208.67.222.222 (OpenDNS)
DNS=9.9.9.9
```

اگر فایل وجود نداشته باشد، یک فایل نمونه با سرورهای DNS عمومی محبوب ایجاد می‌شود.

---

## فرمت فایل خروجی

سرورهای فعال در `working_dns.txt` ذخیره می‌شوند:

```
# Working DNS servers - Tested: 2026-01-18 12:00:00
# Test domain: google.com
# Format: IP (response_time_ms)
1.1.1.1 (23ms)
8.8.8.8 (45ms)
9.9.9.9 (67ms)
```

---

## اشتراک‌گذاری با کاربران شبکه‌های محدود

برای کاربرانی که نمی‌توانند پایتون نصب کنند یا فایل اجرایی دانلود کنند:

۱. **محتوای اسکریپت را کپی کنید** (بش یا پاورشل بسته به سیستم‌عامل آن‌ها)
۳. **از طریق چت یا هر روش اشتراک‌گذاری فایل ارسال کنید**
۲. **در یک فایل متنی روی دستگاه آن‌ها paste کنید**
۳. **با پسوند صحیح ذخیره کنید** (`.sh` یا `.ps1`)
۴. **اجرا کنید** - نیازی به نصب نیست!

اسکریپت‌های بش و پاورشل کاملاً مستقل هستند و فقط با ابزارهایی کار می‌کنند که از قبل روی سیستم‌عامل نصب شده‌اند.
</div>